"""Execute a function on button click."""

import adsk.core
import adsk.fusion
import os, sys, importlib, traceback
import tkinter as tk

# from tkinter import ttk
import tkinter.font as tkFont
from typing import Optional, List, Dict, Any

current_dir = os.path.dirname(os.path.abspath(__file__))
script_dir = os.path.dirname(current_dir)  # C:\FusionAPI\Scripts
sys.path.append(script_dir)
# library import
"""
C:\FusionAPI\Scripts
│
├─library
│  ├─lib_util.py
│  ├─lib_2d.py
├─test
│  ├─menu.py (This script)
"""
from library import lib_util, lib_2d


##---------------------------
def disp_message(msg: str):
    lib_util.disp_message(msg)


# ------------------------------------------------------------------
# ダイアログクラス
# ------------------------------------------------------------------
class DialogPanel(tk.Tk):
    """センターライン作画ダイアログ"""

    def __init__(
        self,
        input_defaults: Dict[str, float],
        construction,
        fixed,
    ):
        super().__init__()
        # self.my_font = None
        self.input_defaults = input_defaults
        self.x_width: float = 0.0
        self.y_width: float = 0.0
        self.z_width: float = 0.0
        self.construction: bool = construction
        self.fixed: bool = fixed
        self.widths: dict[str, tk.DoubleVar] = {}
        self._create_widgets()

    def _simple_frame(self, **kwargs) -> tk.Frame:
        # Fontインスタンスを作成
        self.my_font = tkFont.Font(family="Arial", size=10, weight="normal")
        """単純フレームを作成し、ウィンドウ全体に展開"""
        master = self
        frame = tk.Frame(master, **kwargs)
        master.title("Center Line")
        frame.pack(fill="both", expand=True, padx=5, pady=5)
        return frame

    def _create_widgets(self):
        """全てのUI要素を作成"""
        # 全体を包む単一のフレーム
        self.main_frame = self._simple_frame(relief="ridge", bd=5)

        # ------------------
        # 0. トップメッセージ
        # ------------------
        row_idx = 0
        top_frame = tk.Frame(self.main_frame)
        top_frame.grid(row=row_idx, column=0, columnspan=3, pady=10)
        tk.Label(
            top_frame,
            text="各軸の長さを指定してください。\n作成したくない軸は「0.0」にしてください",
            bg="light cyan",
            font=self.my_font,
        ).pack()
        # ------------------
        # 1～3 各軸幅入力ボックス
        # ------------------

        row_idx += 1
        # 事前設定のラベルとデフォルト値
        for label, default in self.input_defaults.items():
            tk.Label(
                self.main_frame,
                text=label,
                font=self.my_font,
            ).grid(
                row=row_idx,
                column=0,
                sticky="e",
            )
            var = tk.DoubleVar(value=default)
            ent = tk.Entry(
                self.main_frame,
                font=self.my_font,
                textvariable=var,
                width=10,
                bg="lightyellow",
                # bg="ivory",
            )
            ent.grid(row=row_idx, column=1)
            self.widths[label] = var
            row_idx += 1
        # ------------------
        # 4. 要素固定チェック
        # ------------------
        row_idx += 1
        # self.fixed_check = tk.BooleanVar(value=True)
        self.fixed_check = tk.BooleanVar(value=self.fixed)
        check_button = tk.Checkbutton(
            self.main_frame,
            text="要素固定",
            variable=self.fixed_check,
            font=self.my_font,
        )
        check_button.grid(row=row_idx, column=0, padx=5, pady=5, sticky="w")
        # self.construction_check = tk.BooleanVar(value=True)
        self.construction_check = tk.BooleanVar(value=self.construction)
        check_button = tk.Checkbutton(
            self.main_frame,
            text="コンストラクション",
            variable=self.construction_check,
            font=self.my_font,
        )
        check_button.grid(row=row_idx, column=1, padx=5, pady=5, sticky="w")

        # ------------------
        # 5. 最終確定ボタン
        # ------------------
        row_idx += 1
        # ボタンを格納するボトムフレーム
        bottom_frame = tk.Frame(self.main_frame)
        bottom_frame.grid(row=row_idx, column=0, columnspan=3, pady=10)

        tk.Button(
            bottom_frame, text="作成実行", font=self.my_font, command=self.get_data
        ).pack(side=tk.LEFT, padx=10)
        tk.Button(
            bottom_frame, text="閉じる", font=self.my_font, command=self.destroy
        ).pack(side=tk.LEFT, padx=10)

    def get_data(self):
        """入力データを取り出す"""
        v: List = []
        for value in self.widths.values():
            v.append(value.get())
        self.x_width = float(v[0])
        self.y_width = float(v[1])
        self.z_width = float(v[2])
        self.fixed = self.fixed_check.get()
        self.construction = self.construction_check.get()
        self.destroy()


##--------------------------------------------------------------
##--------------------------------------------------------------
def diarog_test(master):
    """センターライン作画"""
    if master:
        master.quit()  # mainloop を終了させる
        master.destroy()
    input_defaults = {
        "X軸長さ": 50.0,
        "Y軸長さ": 50.0,
        "Z軸長さ": 10.0,
    }
    # 線種指定
    construction = True
    fixed = True

    app = DialogPanel(input_defaults, construction, fixed)
    app.mainloop()
    wx = app.x_width
    wy = app.y_width
    wz = app.z_width
    construction = app.construction
    fixed = app.fixed
    try:
        lib_2d.draw_center_line(wx, wy, wz, construction, fixed)
    except:
        disp_message("Failed:\n{}".format(traceback.format_exc()))


# ---- Action command after button click ----------


def print_cmd1():
    disp_message("lambda is not used.")


def print_cmd2(msg: str):
    disp_message(msg)


def exec(function, msg):
    function(msg)


def on_closing(root):
    """Processing when the window's 'x' button is pressed"""
    disp_message("I'll close now!")
    root.quit()  # Terminate the mainloop
    root.destroy()  # Releases window resources.


def button(root: tk.Tk):
    # Window close action
    root.protocol("WM_DELETE_WINDOW", lambda: on_closing(root))
    label1 = tk.Label(root, text="Click the button you like.", bg="light cyan")
    label1.pack()
    tk.Button(root, text="Message1", command=print_cmd1).pack(
        side=tk.LEFT, padx=10, pady=10
    )
    tk.Button(
        root,
        text="Message2",
        command=lambda m="Lambda specification!", f=print_cmd2: exec(f, m),
    ).pack(side=tk.LEFT, padx=10, pady=10)
    tk.Button(
        root,
        text="Draw center line",
        command=lambda tk=root, f=diarog_test: exec(f, tk),
    ).pack(side=tk.LEFT, padx=10, pady=10)
    root.mainloop()


def run(context: dict):  # {'IsApplicationStartup': False}
    root = tk.Tk()
    root.attributes("-topmost", True)  # Bring Window To Top
    button(root)
